;
;***********************
;  DEMO SCAN KEYBOARD  *
;    EXPERIMENT 7      *
;***********************
;
        CPU  "8085.TBL"
        HOF  "INT8"
;
           ORG   2100H

COL:       EQU   0B0H
DAT_DSP:   EQU   0B1H
RD_KEY:    EQU   0B2H
P_SCAN:    EQU   0B2H
P_CTRL:    EQU   0B3H
;
;***********************
;      MAIN PROGRAM    *
;***********************
;
START:  MVI  A,88H
        OUT  P_CTRL
        LXI  H,K_PRESS
        MVI  M,0
        CALL FILL
;
START1: CALL SCANK           ;get key
        JMP  START1
;
;***********************
;        SCAN KEY      *
;***********************

SCANK:  CALL SCAN            ;key press
        CPI  0FFH
        JZ   SCANK           ;not press goto loop
        CALL KEY_NEW         ;key release ?
        JC   SCANK
        CALL KEY_CODE        ;yes for change code
        CALL DSP             ;fill dsp buffer
        RET
;
;/* scan column & in 4 row */

SCAN:   MVI  B,4             ;counter 4 column
        MVI  C,0FEH          ;start column
        LXI  H,DISPY
        SHLD MEMX
;
SCAN_LP:
        CALL SCANC           ;read  row
        IN   RD_KEY
        ANI  70H
        CPI  70H
        JNZ  SCAN_L2
;
        MOV  A,C             ;next column
        RLC
        MOV  C,A
        DCR  B
        JNZ  SCAN_LP
;
        LDA  K_PRESS         ;end scan
        ANI  0FEH
        STA  K_PRESS
        MVI  A,0FFH
SCAN_L2:
        RET
;
;***********************
; GET COLUMN & DISPLAY *
;***********************

SCANC:  PUSH B
        MOV  A,C             ;out column of key
        OUT  P_SCAN

        MVI  A,0             ;clear data dsp buffer
        OUT  DAT_DSP

        LHLD MEMX            ;load address dsp buffer
        LXI  B,DISPY
        MOV  A,L
        SUB  C
        ANI  3
        MOV  C,A
        MVI  B,0
        LXI  H,DAT1          ;get column to display
        DAD  B

        MOV  A,M             ;out column of display
        OUT  COL

        LHLD MEMX            ;fill data to dsp buffer
        MOV  A,M
        OUT  DAT_DSP
        INX  H               ;next dsp buf
        SHLD MEMX

        MVI  A,80H           ;delay column
SCANC1: DCR  A
        JNZ  SCANC1
        POP  B
        RET
;
;***********************
; FILL DATA TO DSP BUF *
;***********************

DSP:    MOV  C,A             ;lfind address dsp buffer
        MVI  B,0
        LXI  H,DAT
        DAD  B
        MOV  D,M
        ANI  3
        MOV  C,A
        MVI  B,0
        LXI  H,DISPY
        DAD  B
        MOV  A,M
        XRA  D               ;toggle data
        MOV  M,A
        RET
;
;***********************
;     DATA OF START    *
;***********************

FILL:   LXI  H,DISPY
        MVI  B,4
;
FILL1:  MVI  M,0E0H
        INX  H
        DCR  B
        JNZ  FILL1
        RET
;
;***********************
;   CHECK KEY RELEASE  *
;***********************

KEY_NEW:
        MOV  L,A
        LDA  K_PRESS
        ANI  1
        STC
        JNZ  KEY_NEW1
        ORI  1
        STA  K_PRESS
KEY_NEW1:
        MOV  A,L
        RET
;
;***********************
;        KEY CODE      *
;***********************

KEY_CODE:
        MOV  B,A
        MOV  A,C
        ANI  0FH
        ORA  B               ;or row & column

        LXI  H,KEYTAB        ;address for code
        MVI  B,0
K_CODE1:
        INR  B
        CMP  M               ;compare for match
        INX  H
        JNZ  K_CODE1
        DCR  B
        MOV  A,B
        RET
;
KEYTAB:
          DFB  6EH,6DH,6BH,67H
          DFB  5EH,5DH,5BH,57H
          DFB  3EH,3DH,3BH,37H

DAT:
          DFB  80H,80H,80H,80H
          DFB  40H,40H,40H,40H
          DFB  20H,20H,20H,20H

DAT1:     DFB  20H,10H,8,4


          ORG  3000H
DISPY:    DFS  4
MEMX:     DFS  2
K_PRESS:  DFS  1
          END
